/* CWMCU.h - header file for CyWee digital 3-axis gyroscope
 *
 * Copyright (C) 2014 Cywee Motion Group Ltd.
 * Author: cywee-motion <cywee-motion@cywee.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef __CWMCUSENSOR_H__
#define __CWMCUSENSOR_H__
#include <linux/ioctl.h>

#define CWMCU_I2C_NAME "CwMcuSensor"

enum ABS_status {
	CW_ABS_X = 0x01,
	CW_ABS_Y,
	CW_ABS_Z,
	CW_ABS_X1,
	CW_ABS_Y1,
	CW_ABS_Z1,
	CW_ABS_TIMEDIFF,
	CW_ABS_TIMESTAMP,
	CW_ABS_TIMESYNC,
	CW_ABS_MAG_ACCURACY = 0x0A,
	CW_ABS_ORI_ACCURACY = 0x0B,
};


enum MCU_handle {
	CW_NONWAKEUP = 0x00,
	CW_WAKEUP,
	CW_HANDLE_ID_END
};

enum MCU_mode {
	CW_NORMAL = 0x00,
	CW_SLEEP,
	CW_NO_SLEEP,
	CW_BOOT,
	CW_SUSPEND
};

enum MCU_status {
    CW_VAILD = 0x00,
    CW_INVAILD
};

/* interrupt status */
typedef enum {
	INTERRUPT_NONE = 0,
	INTERRUPT_MCU_INIT,
	INTERRUPT_STREAM_NONWAKEUP,
	INTERRUPT_STREAM_WAKEUP,
	INTERRUPT_BATCH_NONWAKEUP,
	INTERRUPT_BATCH_WAKEUP,
	INTERRUPT_BATCH_FLUSH,
	INTERRUPT_ERROR_LOG,
	INTERRUPT_DEBUG_LOG,
	INTERRUPT_TIME_SYNC,
	INTERRUPT_DATAREADY,
	INTERRUPT_STATUS_ALL
} INTERRUPT_STATUS_LIST;


/* calibrator command */
typedef enum {
	CWMCU_CALIBRATOR_SENSORS       = 1,
	CWMCU_CALIBRATOR_GETBIAS       = 2,
	CWMCU_CALIBRATOR_SETBIAS       = 3,
	CWMCU_CALIBRATOR_WRITEFLASH    = 4,
} CALIBRATOR_CMD;

/* firmware command */
typedef enum {
    CHANGE_TO_BOOTLOADER_MODE = 1, /*  firmware upgrade command  */
    CHANGE_TO_NORMAL_MODE     = 2, /*  firmware upgrade command  */
    MCU_IMAGE_WRITE           = 3, /*  firmware upgrade command  */
    MCU_IMAGE_ERASE  		  = 4, /*  firmware upgrade command  */
} FIRMWARE_CMD;

/* mcu command */
typedef enum {
    MCU_REGISTER_WRITE_CTRL     = 1,
    MCU_REGISTER_READ_CTRL      = 2,
    CHECK_ACC_DATA              = 7,
    CHECK_MAG_DATA              = 8,
    CHECK_GYRO_DATA             = 9,
	SET_SENSORHUB_DATA_MODE		= 10,
	/* X2Pro KK */
	WDT_FEED_STATUS             = 16,
    MCU_DBG_INT_SWITCH          = 17,
    SET_PROXIMITY_THRESHOLD     = 18,
	SET_INTERRUPT_ENABLE		= 19,
} MCU_CMD;



/* sensor id */
typedef enum {
	CW_ACCELERATION					= 0,
	CW_MAGNETIC						= 1,
	CW_GYRO							= 2,
	CW_LIGHT						= 3,
	CW_PROXIMITY					= 4,
	CW_PRESSURE						= 5,
	CW_HEARTBEAT                    = 6,
	CW_ORIENTATION					= 7,
	CW_ROTATIONVECTOR				= 8,
	CW_LINEARACCELERATION			= 9,
	CW_GRAVITY						= 10,
	CW_MAGNETIC_UNCALIBRATED		= 11,
	CW_GYROSCOPE_UNCALIBRATED		= 12,
	CW_GAME_ROTATION_VECTOR			= 13,
	CW_GEOMAGNETIC_ROTATION_VECTOR	= 14,
	CW_STEP_DETECTOR				= 15,
	CW_STEP_COUNTER					= 16,
	CW_SIGNIFICANT_MOTION			= 17,
	CW_TILT							= 18,
	CW_PDR                          = 19,
    CW_SINGLE_SNAP                  = 20,
	CW_DOUBLE_SNAP                  = 21,
	CW_TAP                          = 22,
    CW_CONTEXT_AWARE                = 23,
	CW_REAR_CAMERA                  = 24,
	CW_PROXIMITY_GESTURE			= 25,
	CW_LIGHT_RGB					= 26,
	CW_SENSORS_ID_END,
	CW_META_DATA					= 99,
	CW_MAGNETIC_UNCALIBRATED_BIAS	= 100,
	CW_GYROSCOPE_UNCALIBRATED_BIAS	= 101
} CW_SENSORS_ID;

#define CW_FWVERSION							0x3A

/*  0x01 ~ 0x0F  */
#define	CW_HOST_ACTIVATE		  				0x01
#define	CW_HOST_BATCH			  				0x02
#define	CW_ENABLE_STATUS		  				0x03
#define	CW_SENSORS_DELAY_SET	  				0x04
#define CW_SENSOR_DELAY_ID_SET                  0x07
#define CW_SENSOR_DELAY_GET                     0x08
#define CW_SYSTEM_SUSPEND						0x0A
#define CW_SYSTEM_RESUME						0x0B
#define CW_REPORT_SENSORS_LIST					0x0C
#define	CW_INTERRUPT_STATUS		  				0x0F

/*  0x10 ~ 0x1F  */
#define	CW_BATCH_ENABLE_STATUS					0x10
#define	CW_BATCH_TIMEOUT						0x11	//4Byte	ms
#define	CW_BATCH_FLUSH							0x12
#define	CW_BATCH_NONWAKEUP_COUNT				0x13
#define	CW_BATCH_NONWAKEUP_EVENT				0x14
#define	CW_BATCH_WAKEUP_COUNT					0x15
#define	CW_BATCH_WAKEUP_EVENT					0x16
#define	CW_BATCH_TIME_SYNC						0x17
#define	CW_BATCH_NONWAKEUP_ONCHANGEQ_COUNT		0x18
#define	CW_BATCH_NONWAKEUP_ONCHANGEQ_EVENT		0x19
#define	CW_BATCH_WAKEUP_ONCHANGEQ_COUNT			0x1A
#define	CW_BATCH_WAKEUP_ONCHANGEQ_EVENT			0x1B

/*  0x20 ~ 0x2F  */
#define	CW_STREAM_WAKEUP_COUNT					0x23
#define	CW_STREAM_WAKEUP_EVENT					0x24
#define	CW_STREAM_NONWAKEUP_COUNT				0x25
#define	CW_STREAM_NONWAKEUP_EVENT				0x26
#define	CW_STREAM_NONWAKEUP_ONCHANGEQ_COUNT		0x28
#define	CW_STREAM_NONWAKEUP_ONCHANGEQ_EVENT		0x29
#define	CW_STREAM_WAKEUP_ONCHANGEQ_COUNT		0x2A
#define	CW_STREAM_WAKEUP_ONCHANGEQ_EVENT		0x2B


/* SelfTest Register */
#define CW_SELFTEST_SENSOR                      0x40
#define CW_SELFTEST_STATUS               		0x41
/* Calibrator Register */
#define CW_CALIBRATOR_SENSOR					0x42
#define CW_CALIBRATOR_STATUS					0x43
#define CW_CALIBRATOR_FLASHWRITE_SENSOR_BIAS    0x44
#define CW_CALIBRATOR_GET_BIAS_ACC              0x45
#define CW_CALIBRATOR_GET_BIAS_MAG              0x46
#define CW_CALIBRATOR_GET_BIAS_GYRO             0x47
#define CW_CALIBRATOR_GET_BIAS_PROXIMITY		0x48
#define CW_CALIBRATOR_SET_BIAS            		0x49


/* Read Sensor Data (0x60 ~ 0x7F)*/
#define CWMCU_I2C_SENSORS_REG_START             (0x60)
#define CW_READ_ACCELERATION                    (CWMCU_I2C_SENSORS_REG_START + CW_ACCELERATION)
#define CW_READ_MAGNETIC                        (CWMCU_I2C_SENSORS_REG_START + CW_MAGNETIC)
#define CW_READ_GYRO                            (CWMCU_I2C_SENSORS_REG_START + CW_GYRO)

/*  0x80 ~ 0x8F  */
#define CW_STEP_COUNTER_SET						0X80
#define CW_STEP_COUNTER_RESET					0X81
#define CW_ACCURACY								0X82
#define CW_MCU_TIMESTAMP						0X83


/*  0x90 ~ 0xAF  */
#define CW_POWER_CTRL				0x90
#define CW_VOICE_TRIGGER_CTRL		0x91
#define CW_LED_CTRL             	0x92
#define CW_MAG_GET_VENDOR_TYPE		0x93
#define CW_MCU_STATUS_SET			0x94
#define CW_MCU_STATUS_GET			0x95
/* mcu log */
#define CW_DEBUG_INFO_GET       	0x96
#define CW_DEBUG_COUNT_GET      	0x97
#define CW_ERROR_INFO_GET       	0x98
#define CW_ERROR_COUNT_GET      	0x99
#define CW_PSENSOR_RAW_DATA_GET     0x9A    //(read, 1 byte)
#define CW_WDT_FEED_STATUS          0x9B    //(write, 0 : no feed, 1 :
#define CW_MCU_DBG_INT_SWITCH       0x9C    //(write, 0 : disable, 1 :
#define CW_SET_PROXIMITY_THRESHOLD	0x9D    //(write 2 bytes)
#define CW_SET_STEP_COUNTER  		0x9E    //(write 4 bytes)
#define CW_SET_INTERRUPT_ENABLE  	0x9F    //(write 1 bytes)


/* check data of queue if queue is empty */
#define CWMCU_NODATA	0xff

#define DPS_MAX			(1 << (16 - 1))
#ifdef __KERNEL__

struct CWMCU_platform_data {
	unsigned char Acceleration_hwid;
	unsigned char Acceleration_deviceaddr;
	unsigned char Acceleration_axes;
	unsigned char Magnetic_hwid;
	unsigned char Magnetic_deviceaddr;
	unsigned char Magnetic_axes;
	unsigned char Gyro_hwid;
	unsigned char Gyro_deviceaddr;
	unsigned char Gyro_axes;
};
#endif /* __KERNEL */

#endif /* __CWMCUSENSOR_H__ */
